#!/bin/bash
#
# make_csv.sh BLL 20171101
#
# program to take a file and read
# line by line then break out space
# delimited data and put it into variables 
# separated by commas.
#
# it is inteded for use in bulk loading 
# network scan data into mysql/mariadb
#
#
# get the filename from the command line
#
file_name=$1
file_breakout_type=$2
if [ $# -ne 2 ]; then
  echo
  echo "Usage: make_csv.sh <input file name> <conversion type:[ traces|mounts|pings ]>"
  echo 
else  
  while IFS=" " read v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 ; do
#
#
# explanation of tcpdump output
#
#
# The tcpdump is made of the following:
#
# Timestamp Source address Source port     Traffic direction Destination address Destination port TCP flag Sequence number Window size
# --------- --------------------------     ----------------- ------------------------------------ -------- --------------- -----------
#     |            |             |                |                   |                  |            |            |            |
#     +--------+   +---------+---+  +-------------+                   +---------+--------+            |            |            |
#              |             |      |                                           |                     |            |            |
#              |             |      |        +----------------------------------+                     |            |            |
#              |             |      |        |                                                        |            |            |
#              |             |      |        |        +-----------------------------------------------+            |            |
#              |             |      |        |        |                                                            |            |
#              |             |      |        |        |                                                            |            |
#              |             |      |        |        |     +------------------------------------------------------+            |
#              |             |      |        |        |     |                                                                   |
#              |             |      |        |        |     |                                                                   |
#              |             |      |        |        |     |        +----------------------------------------------------------+                        
#              |             |      |        |        |     |        |
#              |             |      |        |        |     |        |
#              V             V      V        V        V     V        V
# i.e.: 12:10:45:950953 Ahost.37245 > Bhost.443.www:.ack 1456283 win 37648
#
# TCP Flag 	Flag in tcpdump 	Flag Meaning
# SYN	 	s 	Syn packet, a session establishment request. The first part of any TCP connection.
# ACK 		ack 	Ack packet, used to acknowledge the receipt of data from the sender. May appear in conjunction with other flags.
# FIN 		f 	Finish flag, used to indicate the sender’s intention to terminate the connection to the receiving host.
# RESET 	r 	Indicates the sender’s intention to immediately abort the existing connection.
# PUSH 		p 	Signals the immediate push of data from the sending host to the receiving host. 
#                       For interactive applications such as telnet, the main issue is the quickest response time,
#                       which this “push” flag signals.
# URGENT 	urg 	Urgent data should take precedence over other data. For example, a Ctrl-C to terminate a FTP download.
# Placeholder 	. 	If the connection does not have a syn, finish, reset, or push flag set, 
#                       this placefolder flag will be found after the destination port.
#                       Note that it also appears in conjunction with the ack flag.
#
# end explanation
#
#
    echo "-----"
    echo "file_name: $file_name"
    echo "file_breakout_type: $file_breakout_type"
    echo "Time of Observation: $v1"
    echo "Protocol: $v2"
    echo "IP and Port: $v3"
    echo "Direction: $v4"
    echo "IP and Port: $v5"
    echo "TCP Flag: $v6"
    echo "Flags: $v7"
    echo "Sequence Number Label: $v8"
    echo "Sequence Number: $v9"
    echo "TCP: $v10"
    echo "Return Sequence Number: $v11"
    echo "Windows Size Label: $v12"
    echo "Window Size: $v13"
    echo "Options Label: $v14"
    echo "Options: $v15 $v16 $v17 $v18 $v19 $v20"
    echo
  done < $file_name
fi 
