#!/bin/bash
#
# turn2csv.sh
#
#
# set data type to convert November 12, 2017 BLL
#
# turns a space delimited text file into a csv
#
# create the file name for the list of files in the directory
if [ "$1"=="SAVE" ] || [ "$1"=="Save" ] || [ "$1"=="save" ]; then
  delit='N'
else
  delit='Y'
fi

d_type="stores"
stores_directory="/sim/arch/zbf4wh/stores"
file_list_name=$stores_directory"/"$d_type"_file_list"
echo "file_list_name: $file_list_name"

#
# create the file name for the csv output file
output_filename="$stores_directory/mounts.csv"
echo "output_filename: $output_filename"
input_directory="$stores_directory"
input_file_name="$input_directory/*-mounts-*"
echo "input_directory: $input_directory"
echo "input_file_name: $input_file_name"
#read -p "any key to continue..." #
# makes a file list to open to work each one and stow it as space delimited vars
echo "file_list_name: $file_list_name"
cd "/sim/arch/zbf4wh/stores"
ls -1 *-mounts-* > $file_list_name 
# debug
#cat $file_list_name
#read -p "any key to continue..." #
#
# read the command line and clear out the old mount.csv file if they want to
#
if [ -e "$output_filename" ]; then
  echo "The file $output_filename exists!"
  if [ "$delit"=="Y" ] || [ "$delit"=="y" ]; then
    echo "Deleting old $output_filename"
    rm $output_filename
  else
    echo "Saving old output file $output_filename and appending to it."
  fi
fi
#
# read lines of the input file list
while read line; do
  #
  #echo $line
  #
  # break the line out into 10 variables
  while IFS=" " read col_1 col_2 col_3 col_4 col_5 col_6 col_7 col_8 col_9 col_10; do
    # echo the variables to the std out for progress report
    echo "\"$col_1\",\"$col_2\",\"$col_3\",\"$col_4\",\"$col_5\",\"$col_6\",\"$col_7\",\"$col_8\",\"$col_9\",\"$col_10\"" 
    # we have 10 columns to fill in the csv file
    # the far right will hold whatever is left after the first nine columns
    # the column widths are 20 for col_1 thru col_9
    # collect the variables in the output file
    echo "\"$col_1\",\"$col_2\",\"$col_3\",\"$col_4\",\"$col_5\",\"$col_6\",\"$col_7\",\"$col_8\",\"$col_9\",\"$col_10\"" >> $output_filename
    #
  done < $line # while IFS=" " read col_1 col_2 col_3 col_4 col_5 col_6 col_7 col_8 col_9 col_10
  #
done < $file_list_name # while read line
rm /sim/arch/zbf4wh/stores/stores_file_list
ls -la mounts.csv
test_time=$(date -u +"%F-%H-%M-%S-Z")
csv_final="$test_time-mounts.csv"
echo "Moving $output_filename to csv/$csv_final"
mv $output_filename  csv/$csv_final
rm /sim/arch/zbf4wh/stores/*-mounts-*
exit 0
