#!/bin/bash
#
# trace_turn2csv.sh
#
#
# set data type to convert V1.0 November 14, 2017 BLL
# 	correct * records   1.1	November 15. 2017 BLL                         
#
# turns a space delimited trace text file into a mysql load csv
#
# create the file name for the list of files in the directory
if [ "$1"=="SAVE" ] || [ "$1"=="Save" ] || [ "$1"=="save" ]; then
  delit='N'
else
  delit='Y'
fi
#set -x
d_type="trace"
trace_directory="/sim/arch/zbf4wh/trace"
file_list_name=$trace_directory"/"$d_type"_file_list"
echo "file_list_name: $file_list_name"

#
# create the file name for the csv output file
output_filename="$trace_directory/traces.csv"
echo "output_filename: $output_filename"
input_directory="$trace_directory"
input_file_name="$input_directory/*-to-*"
echo "input_directory: $input_directory"
echo "input_file_name: $input_file_name"
read -p "any key to continue..." #
# makes a file list to open to work each one and stow it as space delimited vars
echo "file_list_name: $file_list_name"
cd "/sim/arch/zbf4wh/trace"
ls -1 *-to-* > $file_list_name 
# debug
cat $file_list_name
read -p "any key to continue..." #
#
# read the command line and clear out the old mount.csv file if they want to
#
if [ -e "$output_filename" ]; then
  echo "The file $output_filename exists!"
  if [ "$delit"=="Y" ] || [ "$delit"=="y" ]; then
    echo "Deleting old $output_filename"
    rm $output_filename
  else
    echo "Saving old output file $output_filename and appending to it."
  fi
fi
#
# read lines of the input file list
while read line; do
  #
  #echo $line
  #
  # set loop_status going into this while
  loop_status=" "
  # break the line out into 10 variables ....more than we need
  while IFS=" " read col_1 col_2 col_3 col_4 col_5 col_6 col_7 col_8 col_9 col_10; do

    # echo the variables to the std out for progress report
    # echo "\"$col_1\",\"$col_2\",\"$col_3\",\"$col_4\",\"$col_5\",\"$col_6\",\"$col_7\",\"$col_8\",\"$col_9\",\"$col_10\"" 
    #
    # collect the variables in the output file based on line contents
    #

    # output a trace line record with test times, ips, and results if it is a trace record

    # end record identifies when this set is over with
    if [ "$col_1" = "End" ]; then
      # this is the end record
      loop_status="stop build"
    fi
    # System Local record
    if [ "$col_1" = "System" ] && [ "$col_2" = "Local" ]; then
      # this is the ;local test time
      local_test_time=$col_4
#      echo "Local Test Time: $local_test_time"
#      exit 0
    fi
    # System ZULU record 
    if [ "$col_1" = "System" ] && [ "$col_2" = "ZULU" ]; then
      # this is the zulu test time
#      echo "Column 1: $col_1"
#      echo "Column 2: $col_2"
      zulu_test_time=$col_4
     echo "ZULU Test Time: $zulu_test_time"
 #     exit 0
    fi

    

    # trace record
    if [ "$loop_status" != "stop build" ] && [ "$loop_status" = "build record" ] ; then
      # watch for blank or star records
      if [ ! `echo "$col_1" | grep '*'` ]; then
        # this is a trace record
        echo "\"$zulu_test_time\",\"$local_test_time\",\"$source\",\"$destination\",\"$col_1\",\"$col_2\",\"$col_3\"" 
        # echo to progress report
        # the test is tab delimited so bust it out
        test=$col_1
        echo "Test: $test"

        test_sequence_number=`echo $test | awk -F" " '{print $1}'`
        # fix the value if there was no data or it was an *
        if [ -z $test_sequence_number ] || [ "$test_sequence_number" = "*" ] || [ "$test_sequence_number" = " " ] ; then 
          test_sequence_number= "-"
        fi
        echo "Test Sequence Number: $test_sequence_number"


        hop_ip_address=`echo $test | awk -F" " '{print $2}'`
        # fix the value if there was no data or it was an *
        if [ -z $hop_ip_address ] || [ "$hop_ip_address" = "*" ] || [ "$hop_ip_address" = " " ] ; then 
          hop_ip_address= "-"
        fi
        echo "Hop IP Address: $hop_ip_address"

        hop_time=`echo $test | awk -F" " '{print $3}'`
        if [ -z $hop_time ] || [ "$hop_time" = "*" ] || [ "$hop_time" = " " ] ; then 
          hop_time= "-"
        fi
        echo "Hop Time: $hop_time"
    
        # output the full line to csv file
        echo "\"$zulu_test_time\",\"$local_test_time\",\"$source\",\"$destination\",\"$test_sequence_number\",\"$hop_ip_address\",\"$hop_time\"" >> /sim/arch/zbf4wh/trace/traces.csv
      else
        # output the starred test to the output file...any flaw (*) makes a blank with times source and destination
        echo "\"$zulu_test_time\",\"$local_test_time\",\"$source\",\"$destination\",\"*\",\"*\",\"*\"" >> /sim/arch/zbf4wh/trace/traces.csv
      fi

    fi
    # otherwise collect vars for the record build


    # begin record identifies source and destination and lets us set the build flag for later loops
    if [ "$col_1" = "Begin" ]; then
      source=$col_4
      destination=$col_6
      loop_status="build record"
    fi

    #
  done < $line # while IFS=" " read col_1 col_2 col_3 col_4 col_5 col_6 col_7 col_8 col_9 col_10
  #
done < $file_list_name # while read line
rm /sim/arch/zbf4wh/trace/trace_file_list
ls -la /sim/arch/zbf4wh/trace/traces.csv
test_time=$(date -u +"%F-%H-%M-%S-Z")
csv_final="$test_time-traces.csv"
echo "Moving /sim/arch/zbf4wh/trace/traces.csv to /sim/arch/zbf4wh/trace/csv/$csv_final"
mv /sim/arch/zbf4wh/trace/traces.csv  /sim/arch/zbf4wh/trace/csv/$csv_final
rm /sim/arch/zbf4wh/trace/*-to-*
exit 0
