#!/bin/bash
#
#
# comm_the_parse.sh
#
# used to read the fqdn_ip.txt and ip_fqdn.txt
# outputs from parse_findings.sh and do a line
# by line verification
#
# 
clear
echo
echo "****************************************************"
echo "*                                                  *"
echo "*              comm_the_parse.sh                   *"
echo "*                                                  *"
echo "*         fqdn_ip.txt and ip_fqdn.txt              *"
echo "*          contents can be compared                *"
echo "*                                                  *"
echo "*      This script does that comparison.           *"
echo "*                                                  *"
echo "*                                                  *"
echo "****************************************************"
echo
read -p "Hit any key when your ready...Ctl-C to Abort"
# sort one of them to match line info
# show IP first
fname1="fqdn_ip.txt"
fname2="ip_fqdn.txt"
echo
ln_ctr=1
while read  -r adname aip $compareFile1 <&3 && read -r bip bdname compareFile2 <&4; do     
    if [ "$aname"=="$bname" ]; then namecomp="FQDNs Match"
    else
      namecomp="No"
    fi
    if [ "&aip"=="$bip" ]; then ipcomp="IPs Match"
    else
      ipcomp="No"
    fi
    echo 
    echo "Comparing the file $fname1 to the file $fname2 on line $( printf '%d' $ln_ctr ):"
    echo
    echo "Host Names ====> $adname to $bdname     $namecomp"
    echo
    echo "IP Addresses ==> $aip to $bip     $ipcomp"
    echo
    ((ln_ctr++))
done 3<$fname1 4<$fname2

