#!/bin/bash
#
# parse_findings.sh
#
# script to extract ;;ANSWER SECTION from findings
# file created by the read_ip_list.sh script
#
# use the findings file
fname="findings"
#
# name the output files
ip_fqdn="ip_fqdn.txt"
fqdn_ip="fqdn_ip.txt"
#
# read the lines in
while IFS=' ' read -r line; do

  # for debug
  #echo $line

  # if the $line is one after the ANSWER SECTION line
  # this step will parse it
  if [ "$good_next_line" == '1' ];
    then
    # pass $line in here
    line_to_parse=$line
    # tell em
    echo "Parsing --> $line_to_parse"
    # separate into 5 variables
    read v1 v2 v3 v4 v5 <<< $line_to_parse
    # separate out the ip octets
    IFS='.' read -r i1 i2 i3 i4 i5 i6 <<< $v1
    # write the reverse ip address out in the correct forward order
    dns_ip="$i4.$i3.$i2.$i1"
    # pass in the hostname
    fqdn=$v5
    # separate the hostname into 4 variables 
    # i.e.: host.ad.onsemi.com -> host ad onsemi com
    IFS='.' read -r d1 d2 d3 d4 <<< $fqdn    
    # reassemble the fqdn without trailing periods
    fqdn_2="$d1.$d2.$d3.$d4"
    # output the results to files
    echo "IP and FQDN output of $dns_ip $fqdn_2 to file: $ip_fqdn"
    echo -e "$dns_ip  $fqdn_2" >> $ip_fqdn
    echo "FQDN and IP output of $fqdn_2 $dns_ip to file: $fqdn_ip"
    echo -e "$fqdn_2  $dns_ip" >> $fqdn_ip
    # reset the ANSWER line flag
    good_next_line='0'
  fi

  # Set the answer line flag based on what you read 
  # on this line one above the data you want.
  # Then the next line records contents will be parsed
  # in the while loop.
  # It will only cause the next line to be parsed.
  # Multiple ANSWER SECTION lines will be missed
  # after the first line.
  if [[ $line == *'ANSWER SECTION'* ]]; then
    good_next_line='1' 
  else
    good_next_line='0'
  fi

done < $fname

exit 0 
