#!/bin/bash
#
# readline.sh
#
# script to dig ip addresses and store the findings
#
# 
clear
echo
echo "***********************************************"
echo "*                                             *"
echo "*              read_ip_list.sh                *"
echo "*                                             *"
echo "*      Performs dig @<domain> -x<ip>          *"
echo "*                                             *"
echo "*       Input file format must be:            *"
echo "*               IP,Domain                     *"
echo "*      and have a csv file extension.         *"
echo "*                                             *"
echo "*    It can be produced from SolarWinds       *"
echo "*            as an XLS export.                *"
echo "*    In Excel convert it to csv format.       *"
echo "*                                             *"
echo "***********************************************"
echo
#
# clean up when three backups exist - clean off third
if [ -e "findings.bak.bak.bak" ]
   then
   echo "Previous findings.bak.bak.bak file removed"
   rm -rf findings.bak.bak.bak
   echo
fi

#
# clean up when two backups exist - third backup
if [ -e "findings.bak.bak" ]
   then
   echo "Previous findings.bak.bak file moved to findings.bak.bak.bak"
   echo
   echo "The next time this script is run findings.bak.bak.bak will"
   echo "be removed.  Save it after this run if you need it!"
   cp findings.bak.bak findings.bak.bak.bak
   rm -rf findings.bak.bak
   echo
fi

#
# clean up when one backup exists - second backup
if [ -e "findings.bak" ]
   then
   echo "Previous findings.bak file moved to findings.bak.bak"
   cp findings.bak findings.bak.bak
   rm -rf findings.bak
   echo
fi

#
# clean up from previous use - first backup
if [ -e "findings" ]
   then
   echo "Previous findings file moved to findings.bak"
   cp findings findings.bak
   rm -rf findings
   echo
fi
#
# list what csv file are available
echo "CSV files in this directory are:"
echo
ls -1 *.csv
echo
#
# init the filename and ask
fname=""
read -p "What filename?: " fname
echo
#
# if we have a good filename then do this
if [ -e "$fname" ]
  then
  # read file line into ip and domain name variables till eof
  while IFS="," read -r ip dname; do
    # tell them
    echo "Processing IP: $ip   and Domain Name: $dname"
    # do it and put the results in findings
    echo `dig @$dname +answer -x$ip >> findings`
    # give dig a few seconds to 
    # write out and go to the next line
    sleep 5
  done < $fname

else # if we have a bad file name

  echo
  echo "Bad filename or file not found...exitiing"
  # exit with a bad
  exit 1

fi # [ -e "$fname" ] then

# exit with a good
exit 0


