#!/bin/bash
#
# move_solarwinds_data.sh v.9 BLL Bernard.Lambert@onsemi.com
#
if [ "$#" -ne 2 ]; then
  echo "usage: $0 <username> <password>"
else

  # set the starting directory the script is in
  script_dir=`pwd

  # set the expect script name
  script_name="move_solarwinds_data.exp"   

  # set the pwd into the destination directory where the files end up
  dst_dir="/sim/arch/zbf4wh/SolarWindsNetflow"

  # now start there
  cd $dst_dir

  # set the log directory date and name
  logdir="/home/zbf4wh/Scripts/expect/solarwinds_netflow_copy_logs/"
  logdate=$(date +'%Y-%m-%d-%H-%M-%S')
  logname=$logdir"move_solarwinds_data_"$logdate".log"

  # run the script with the user name and password ( note escape < use the \ > on any unusual characters in password )
  expect -d $script_dir$script_name $1 $2 $logname >> $logname

fi # [ "$#" -ne 2 ]


