#!/bin/bash
#
# load_mysql_import.sh
#
# modified for move to new database warehouse 1/29/2018
#
## (deprecated) program reads directory /sim/arch/zbf4wh/SolarWindsNetflow/csv 
# (1-29-2018) program reads directory /home/zbf4wh/import
# and creates a file list to feed to the do while script at line 31
#
#
# some shorthand
#
#src_directory="/sim/arch/zbf4wh/SolarWindsNetflow/csv"
src_directory="/home/zbf4wh/import"
#
# now the import requires the submitted file to have the table name
# so we have to change them one at a time and submit them to the import script
#
#set x-
#
started_at=$(date +'%Y-%m-%d-%H-%M-%S')
#
#
#ls -1 /sim/arch/zbf4wh/SolarWindsNetflow/csv/*.csv > /home/zbf4wh/Scripts/mysql/load_file_list
ls -1 /home/zbf4wh/import/*.csv > /home/zbf4wh/Scripts/mysql/load_file_list
cat /home/zbf4wh/Scripts/mysql/load_file_list
rec_count=0
empty_recs=0
rec_total=0
while read line; do
  echo $line
  #sleep 1
  # check for empty records or ones with just the headers
  line_count=$(cat "$line" | wc -l)
  echo "Line count of "$line" is "$line_count
  #sleep 1
  # go if there are 2 or more records
  if [ "$line_count" -gt 1 ]; then
    # record the number of records added less the header one skipped at the top
    rec_count=$((line_count-1))
    rec_total=$(( rec_total + rec_count )) 
    # copy the file to done area
#    cp "$line" "/sim/arch/zbf4wh/SolarWindsNetflow/done/"
    cp "$line" "/home/zbf4wh/SolarWindsNetflow/done/"
#    echo "File $line copied to /sim/arch/zbf4wh/SolarWindsNetflow/done/"
    echo "File $line copied to /home/zbf4wh/SolarWindsNetflow/done/"
    # rename the file to netflows.csv - the file name must be the tablename with the extension ignored - here the table in the database is netflows
#    mv "$line" "/sim/arch/zbf4wh/SolarWindsNetflow/csv/netflows.csv"
    mv "$line" "/home/zbf4wh/SolarWindsNetflow/csv/netflows.csv"
    echo "File $line moved to /home/zbf4wh/SolarWindsNetflow/csv/netflows.csv"
    #sleep 1
    # seed the command
    mysqlimport="mysqlimport"
    # user -u root
    user="root"
    # pass
    pass="onsemi"
    #
    # add the user and pass to the command line
    mysqlimport=$mysqlimport" -u"$user" -p"$pass
    #
    # add to the command line to ignore line 1 to not load the column headers and add local and add field terminator or , (comma) - tab is default
    mysqlimport=$mysqlimport" --ignore-lines=1 --local --fields-terminated-by=,"
    #
    # database -p Database
    db_name="network_study"
    # 
    # add the database to the command line
    mysqlimport=$mysqlimport" "$db_name
    #
    # csv data file source directory and filename add to command line
#    mysqlimport=$mysqlimport" /sim/arch/zbf4wh/SolarWindsNetflow/csv/netflows.csv"
    mysqlimport=$mysqlimport" /home/zbf4wh/SolarWindsNetflow/csv/netflows.csv"
    echo "The completed command line is: "$mysqlimport
    sleep 1
    echo -e `$mysqlimport`
#    echo " Removing file /sim/arch/zbf4wh/SolarWindsNetflow/csv/netflows.csv after importing it."
    echo " Removing file /home/zbf4wh/SolarWindsNetflow/csv/netflows.csv after importing it."
#    rm /sim/arch/zbf4wh/SolarWindsNetflow/csv/netflows.csv
    rm /home/zbf4wh/SolarWindsNetflow/csv/netflows.csv
    #sleep 1
  else
    echo "Line count of "$line" is "$line_count" ....skipping import and deleting the file!"
    rm $line
    ((empty_recs++))
    #sleep 1
  fi 
done < /home/zbf4wh/Scripts/mysql/load_file_list
ended_at=$(date +'%Y-%m-%d-%H-%M-%S')
#echo "The load_mysql_import.sh ran beginning at: "$started_at" and ending at: "$ended_at > /sim/arch/zbf4wh/SolarWindsNetflow/archive/RunInfo.txt
echo "The load_mysql_import.sh ran beginning at: "$started_at" and ending at: "$ended_at > /home/zbf4wh/SolarWindsNetflow/archive/RunInfo.txt
#echo "to bulk load a total of "$rec_total" records were added to the network_study database, table netflows, host 10.253.82.59, user root" >> /sim/arch/zbf4wh/SolarWindsNetflow/archive/RunInfo.txt
echo "to bulk load a total of "$rec_total" records were added to the network_study database, table netflows, host 10.253.83.9, user root" >> /home/zbf4wh/SolarWindsNetflow/archive/RunInfo.txt
#echo $empty_recs" empty record or header only file(s) found and deleted." >> /sim/arch/zbf4wh/SolarWindsNetflow/archive/RunInfo.txt
echo $empty_recs" empty record or header only file(s) found and deleted." >> /home/zbf4wh/SolarWindsNetflow/archive/RunInfo.txt
#tar -cvjf  /sim/arch/zbf4wh/SolarWindsNetflow/archive/Completed-$ended_at.tar.bz2 /sim/arch/zbf4wh/SolarWindsNetflow/done/*.csv /sim/arch/zbf4wh/SolarWindsNetflow/archive/RunInfo.txt
tar -cvjf  /home/zbf4wh/SolarWindsNetflow/archive/Completed-$ended_at.tar.bz2 /home/zbf4wh/SolarWindsNetflow/done/*.csv /home/zbf4wh/SolarWindsNetflow/archive/RunInfo.txt
#
# ask to clean out loaded files
echo "All data sets in /home/zbf4wh/SolarWindsNetflow/csv/ have been loaded into mysql"
echo "and archived into /home/zbf4wh/SolarWindsNetflow/archive/Completed-"$ended_at".tar.bz2"
read -p "Delete CSV data files? Y/N?" clean
if [ "$clean" == "Y" ]; then
  rm -f /home/zbf4wh/SolarWindsNetflow/done/*.csv
  rm -f /home/zbf4wh/SolarWindsNetflow/archive/RunInfo.txt
fi
rm /home/zbf4wh/Scripts/mysql/load_file_list
exit 0
