#!/bin/bash
#
# mysql_import_csv.sh
#
# bulk import csv file to a mysql data base
#
if [ ! $# -eq 5 ]; then
  echo "Usage: "$0" <ignore-lines=1> <user> <user pass> <dst database name> <file to load>"
  exit 1
fi
# directory name of file(s) to import
d_name=$1
# file name of file to import
f_name=$2
# ignore lines if there are field names at the top --ignore-lines=1
#i_amount=$3
# field terminators --fields-terminated-by=,
#t_desc=$4
# local --local 
#local=$5
# user -u root
user=$3
# pass
pass=$4
# database -p Database
db_name=$5
# table name TableName.csv
tb_name="netflows"
# seed the command
mysqlimport="mysqlimport"
# build the command based on parameters passed in
#
# ignore lines
#if [ ! "$i_amount" == 0 ]; then
#  mysqlimport=$mysqlimport" --fields-terminated-by="$i_amount
#fi
# terminators
#if [ ! "$t_desc" == "," ]; then
mysqlimport=$mysqlimport" --ignore-lines=1"
#fi
# local
#if [ "$local" == "y" ] || [ "$local" == "Y" ]; then
#  mysqlimport=$mysqlimport" --local"
#fi
#set -x
# user
echo $user
if [ ! -z "$user" ];then
  mysqlimport=$mysqlimport" -u"$user
else
  echo "No user specified. Check usage by entering ./mysql_import_csv.sh at the prompt"
  exit 3
fi
if [ ! -z "$pass" ];then
  mysqlimport=$mysqlimport" -p"$pass
else
  echo "No password specified. Check usage by entering ./mysql_import_csv.sh at the prompt"
  exit 4
fi
#set +x
if [ ! -z "$db_name" ];then
  mysqlimport=$mysqlimport" "$db_name
else
  echo "No database specified. Check usage by entering ./mysql_import_csv.sh at the prompt"
  exit 5
fi
#if [ ! -z "$tb_name" ];then
#  mysqlimport=$mysqlimport"."$tb_name
#else
#  echo "No table name specified. Check usage by entering ./mysql_import_csv.sh at the prompt"
#  exit 6
#fi
# source directory
if [ ! -z "$d_name" ]; then
   mysqlimport=$mysqlimport" "$d_name
else
  echo "No source directory specified. Check usage by entering ./mysql_import_csv.sh at the prompt"
  exit 1
fi
# source filename
if [ ! -z "$f_name" ]; then
   mysqlimport=$mysqlimport"/"$f_name
else
  echo "No source file name specified. Check usage by entering ./mysql_import_csv.sh at the prompt"
  exit 2
fi


echo "Command is: "$mysqlimport
echo -e `$mysqlimport` 
exit 0
