// simple scandir example
<?php
$dir    = '/tmp';
$files1 = scandir($dir);
$files2 = scandir($dir, 1);

print_r($files1);
print_r($files2);
?>
// output
//Array
//(
//    [0] => .
//    [1] => ..
//    [2] => bar.php
//    [3] => foo.txt
//    [4] => somedir
//)
//Array
//(
//    [0] => somedir
//    [1] => foo.txt
//    [2] => bar.php
//    [3] => ..
//    [4] => .
//)

//directory to atrray
<?php
function dirToArray($dir) {
  
   $result = array();

   $cdir = scandir($dir);
   foreach ($cdir as $key => $value)
   {
      if (!in_array($value,array(".","..")))
      {
         if (is_dir($dir . DIRECTORY_SEPARATOR . $value))
         {
            $result[$value] = dirToArray($dir . DIRECTORY_SEPARATOR . $value);
         }
         else
         {
            $result[] = $value;
         }
      }
   }
  
   return $result;
}
?>

//Output
//Array
//(Easy way to get rid of the dots that scandir() picks up in Linux environments:

<?php
$directory = '/path/to/my/directory';
$scanned_directory = array_diff(scandir($directory), array('..', '.'));
?>
//   [subdir1] => Array
//   (
//      [0] => file1.txt
//      [subsubdir] => Array
//      (
//         [0] => file2.txt
//         [1] => file3.txt
//      )
//   )
//   [subdir2] => Array
//   (
//    [0] => file4.txt
//   }
//)

//Easy way to get rid of the dots that scandir() picks up in Linux environments:
<?php
$directory = '/path/to/my/directory';
$scanned_directory = array_diff(scandir($directory), array('..', '.'));
?>
//
