#!/bin/bash
#
# make_bzips.sh
#
# script creates subdir, puts files in it, and makes a tar/bzip2 in working directory
#
if [ -z $1 ]; then
  echo "Useage: $0 < region file mask i.e.: AP|NA|EMEA|ALL >"
  echo "Do ALL last to pick up errors or faulty records for last archive."
  exit 1
fi

mask=$1

mkdir tmp$mask

if [ ! "$mask" == "ALL" ]; then

  mv out/$mask* tmp$mask/.
  tar cjvf $mask.tar.bz2 tmp$mask/*
  rm tmp$mask/*
  rmdir tmp$mask

else

  mv out/* tmp$mask/.
  tar cjvf $mask.err.tar.bz2 tmp$mask/*
  rm tmp$mask/*
  rmdir tmp$mask

fi

exit 0
