#!/bin/bash
#
# make_snmp_conf.sh
#

#
# Determine whether bulk or one-off:
# Bulk will have a single parameter passed in that is a file name.
# One-off will have no parameters passed in but will require answers for each parameter.
#
# Test for one parameter passed in
# 
if [ $# -eq 1 ]; then
  mode='bulk'
else
  mode='one'
fi
echo "mode is: $mode"

# The parameters showing on the original equipment spreadsheet are below.
# They are needed for a complete snmpd.conf file to be used by zabbix.
# The originals are as follows:
#
#  1.	Business Group 
#  2.	Region		
#  3.	Sitecode
#  4.	Site Description
#  5.	Host Name
#  6.	DNS Domain
#  7.	Group
#  8.	Hardware Model Name
#  9.	Age
# 10.	Last Check-in Date
# 11.	Last Kickstart Date
# 12.	Kickstart Count
# 13.	Last Boot Update
# 14.	Kernel Version
# 15.	OS Release
# 16.	Last YUM Update
# 17.	Estimated Manufacturing Date
# 18.	Serial Number
# 19.	CPU Manufacturer
# 20.	CPU Vendor
# 21.	CPU Frequency
# 22.	CPU Family
# 23.	Memory RAM Total
# 24.	Disk System Disk Size
# 25.	Disk Type
# 26.	RAM Speed
# 27.	RAM Type
# 28.	GPU Card
# 29.	Satellite Registration Status
# 30.	System ID
# 31.	Last Local Users
# 32.	CPU Sockets
# 33.	CPU Physical Cores
# 34.	CPU Total Cores
# 35.	IP Addresses
# 36.	Client IP Address
# 37.	Memory GB
# 38.	Servers
# 39.	Workstations
# 40.	VM
# 41	Unknown
# 42.	Age
# 43.	 < 3 yrs
# 44.	 < 5 yrs
# 45.	 5 to 10 yrs
# 46.	 > 10 yrs	
if [ "$mode" == "one" ]; then
  echo "This begins the one-off Q and A"
else 
  if [ "$mode" == "bulk" ]; then
    if [ -e "$1" ]; then
      #
      # pass the file name to use into a parameter
      in_file=$1
      # 
      # Do a while loop through the file one line at a time to separate
      # out each parameter and write the snmp.conf file for that unique machine.
      rec_ctr=1
      while IFS=$'\t' read v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47; do
	echo "------- Record Number -------: $rec_ctr"
        echo "               Businees Group: $v1"
        echo "                       Region: $v2"
   	echo "                    Site Code: $v3"
	echo "             Site Description: $v4"
	echo "                    Host Name: $v5"
	echo "                   DNS Domain: $v6"
	echo "                        Group: $v7"
	echo "          Hardware Model Name: $v8"
	echo "                          Age: $v9"
	echo "           Last Check-In Date: $v10"
	echo "          Last Kickstart Date: $v11"
	echo "              Kickstart Count: $v12"
	echo "             Last Boot Update: $v13"
	echo "               Kernel Version: $v14"
	echo "                   OS Release: $v15"
	echo "              Last YUM Update: $v16"
	echo " Estimated Manufacturing Date: $v17"
	echo "                Serial Number: $v18"
	echo "             CPU Manufacrurer: $v19"
	echo "                   CPU Vendor: $v20"
	echo "                CPU Frequency: $v21"
	echo "                   CPU Family: $v22"
	echo "             Memory RAM Total: $v23"
	echo "        Disk System Disk Size: $v24"
	echo "                    Disk Type: $v25"
	echo "                    RAM Speed: $v26"
	echo "                     RAM Type: $v27"
	echo "                     GPU Card: $v28"
	echo "Satellite Registration Status: $v29"
	echo "                    System ID: $v30"
	echo "             Last Local Users: $v31"
	echo "                  CPU Sockets: $v32"
	echo "           CPU Physical Cores: $v33"
	echo "                 IP Addresses: $v35"
	echo "            Client IP Address: $v36"
	echo "              Memory Gigabyte: $v37"
	echo "                      Servers: $v38"
	echo "                 Workstations: $v39"
	echo "                           VM: $v40"
	echo "                      Unknown: $v41"
        echo "                          Age: $v42"
	echo "                    < 3 years: $v43"
	echo "                    < 5 years: $v44"
	echo "                5 to 10 years: $v45"
        echo "                   > 10 years: $v46"
        echo "                Any Remainder: $v47"
	#echo 
	# 
	# fix ip addresses line if it is wrong
	# 
	v36=$( echo $v35 | awk '{ print $1 }' ) 
	echo
        echo "  IP to use: "$v36
	outfile="out/"$v2"."$v3".snmp.conf."$v36
        echo "Output File: "$outfile	
        
	#
	# make a file for the machine's snmpd.conf
	#
	# 1st line
	echo "# PDS SNMP configuration file for host name "$v5" on "$(date -u +'%Y-%m-%d-Z') > $outfile
	# second line
	echo "#" >> $outfile 
	# third line
	echo "# community	view name	IP/Hostname (PTR, A, or CNAME)	Description" >> $outfile
	# fourth line
	echo "#--------------	--------------- ------------------------------- -----------------------------------------------------------------" >> $outfile
	# fifth thru tenth lines
	echo "rocommunity	public		10.253.110.130			# dawson.onsemi.com" >> $outfile
	echo "rocommunity 	onsemi-view	pds-zabbix-"$v2".onsemi.com	# CNAME for regional zabbix server" >> $outfile
	echo "rocommunity 	onsemi-view	10.222.65.150			# seahawk.onsemi.com 			APAC SolarWinds" >> $outfile
	echo "rocommunity 	onsemi-view	10.222.0.150			# chinook.onsemi.com 			NA SolarWinds" >> $outfile
	echo "rocommunity 	onsemi-view	10.222.128.150			# jetranger.onsemi.com			EMEA SolarWinds" >> $outfile
	echo "rocommunity 	onsemi-view	10.100.16.121  			# flash.onsemi.com			test machine for snmpwalk" >> $outfile
	#
 	# site based decisions made from here down
	# script logic is based on original spreadsheet and contents of columns
	#
	##Site specific setup:
	#
 	# site admin machine
	echo "#" >> $outfile
	echo "# Specify admin machine here" >> $outfile
	echo "# community	view-name	IP/Hostname			Description" >> $outfile
	echo "#-------------- --------------- ------------------------------- -----------------------------------------------------------------" >> $outfile
	echo "rocommunity	onsemi-view	"$v3"adm.onsemi.com		# CNAME for site admin machine" >> $outfile
	#
	# site code
	echo "#" >> $outfile
	echo "# sysLocation	name (quote enclosed)" >> $outfile
	echo "#-------------- ---------------------" >> $outfile
	echo "sysLocation 	"$v3 >> $outfile
	#
	# system contact e-mail list/group
	echo "#"
	echo "# sysContact	PDS Group E-Mail Address" >> $outfile
	echo "#-------------- ------------------------" >> $outfile
	echo "sysContact  PDS-"$v2"@onsemi.com" >> $outfile
	echo "#" >> $outfile 
	#System description. Replace undefined by one or more items separated by comma:
	##System description. Use one or more items separated by comma:
	#
	#Descriptive Name	Provisioning/Purpose
	#---------------------- -----------------------------------------------------------------------
	#simulationnode		LSF compute machine, simulation node
	#interactivenode	LSF machine running interactive IDE
	#layoutnode		LSF machine running interactive IDE for layout group
	#workstation		user workstation
	#infrastructure		infrastructure server (NIS, CUPS, SAMBA, SQL, Cliosoft,  ...)
	#session		session or logon machine (VNC, NX) running users desktops (KDE, GNOME)
	#hypervisor		hypervisor (KVM, XEN, VMWare server)
	#lab			lab or testing machine, no production
	#
	#
	# example sysDescr ( one or more items searated by comma )
	# only one sysDescr entry per system
        # the sysDescr value in snmpd.conf will be used to hold all the system descriptive information
        #| Hostname | Domain | Hardware Model Name | OS Release | Kernel Version | Estimated Manufacture Date | Serial Number | CPU Manufacturer | CPU Vendor | CPU Frequency | CPU Family | CPU Sockets | CPU Physical Cores | CPU Total Cores | Memory GB | Memory RAM Total | RAM Speed | RAM Type | Disk Type | Disk System Disk Size | GPU Card | IP Addresses | Client IP | Last Checkin | Last Kickstart Date | Last YUM Update | Satellite Registration Status | System ID | Last Local User | Age(9) | Age(42) |
        post_sysDescr=$v5"."$v6","$v8","$v15","$v14","$v17","$v18","$v19","$v20","$v21","$v22","$v32","$v33","$v34","$v37","$v23","$v26","$v27","$v25","$v24","$v28","$v35","$v36","$v10","$v11","$v15","$v29","$v30","$v31","$v9","$v42
	# modify to only have system type recorded in snmp.conf file hereafter BLL 11/28/2017
	# echo all of it to visually verify
	echo "sysDescr "$v7
        echo "postsysDescr "$post_sysDescr
	# this series adds the uses to the prefix of the sysDescr and output to snmp.conf for this system
        echo "sysDescr "$v7 >> $outfile
	# show the finished file
	cat $outfile
	# for debug
	#sleep 5
	(( rec_ctr++ )) 
      done < $in_file
    else
      echo
      echo "You entered $0 $1 at the command prompt"
      echo 
      echo "The input file $1 cannot be found. Please check the name and try again..."
      echo
    fi
  fi
fi
exit 0 





