#!/bin/bash
#
# make_unique_sites.sh
#
# takes long list ( BU-Region-Site-SiteDesc.txt ) with duplicate sites,
# created as the Inventory Sheet from Satellite,
# and makes a list of unique BU, Region, Site Name, and Locale
# output to file unique-BU-Region-Site-SiteDesc.txt
#
#
# set the terminal tabs to 12
tabs 12
#
# sort the input first
sort BU-Region-Site-SiteDesc.txt > sorted_list
#
# clean out old unique file
rm unique-BU-Region-Site-SiteDesc.txt
#
# set last comparison variable
last="" 
#
# set the header printing flag
header="yes"
#
# read in the sorted file
while read v1 v2 v3 v4; do
  unique=$v1" "$v2" "$v3" "$v4
  if [ "$v1" == "Business" ]; then
    last=$unique
  fi
  if [ "$header" == "yes" ]; then  
    echo -e "Business Group\tRegion\tSite Code\tSite Description" >> unique-BU-Region-Site-SiteDesc.txt
    header="no"
  fi
  if [ ! "$unique" == "$last" ]; then
    last=$v1" "$v2" "$v3" "$v4 
    echo -e $v1"\t"$v2"\t"$v3"\t"$v4 >> unique-BU-Region-Site-SiteDesc.txt
  fi
done < sorted_list
#
#
#
# now lets sort the results into Site, BU order
#

rm sorted_list

