#!/bin/bash
#
# make_unique_sites_v2.sh
#
# takes long list sitenames.txt with duplicate sites,
# created by  cat sitelist.txt | awk '{ print $3}' | sort > sorted-sitelist.txt
#
cat sitelist.txt | awk '{ print $3}' | sort > sorted-sitelist.txt
#
# be sure the columns are tab delimited
#
# this makes a list of unique site names
# output to file unique-SiteNames.txt
#
# it is assumed that a single column of sorted input is fed into this script
#
# check for cli input of filename to unique
if [ -z "$1" ]; then
  echo "Be sure input file is BU REGION SITECODE LOCATION"
  echo "in a tab delimited format."
  echo 
  echo "Usage: $0 <sitelist text file>"
  exit 1
else
  echo "Your command was: " $0 $1
  echo "Your file should have these columns:" 
  echo "  BU REGION SITECODE LOCATION"
  echo "in a tab delimited format."
  echo "This script will take out the duplicates"
  echo 
  read -p "Hit any key to continue...Control-C to abort"
fi
#
# clean out old unique file
if [ -f "unique-SiteNames.txt" ]; then
  rm unique-SiteNames.txt
fi
#
# set last comparison variable
last="" 
#
#
# read in the sorted file
while read v1; do
  # start to look at each linr
  unique=$v1
  if [ ! "$unique" == "$last" ]; then
    last=$v1
    echo $v1 
    echo -e $v1 >> unique-SiteNames.txt
  fi
done < sorted-sitelist.txt

exit 0

