#!/bin/bash
#
# set cap_net_admin.sh
#
#
#   First install tcpdump and libcap-progs:
#
#    zypper install tcpdump libcap-progs
#
#    Then create a dedicated group called pcap for users who should be able to run tcpdump and add your user to it:
#
#
#    groupadd pcap
#    usermod -a -G pcap peter
#
#
#    Modify the group ownership and permissions of the tcpdump binary so that only users in the pcap group can run it:
#
#    chgrp pcap /usr/sbin/tcpdump
#    chmod 750 /usr/sbin/tcpdump
#
#    Set the CAP_NET_RAW and CAP_NET_ADMIN capabilities on the tcpdump
#    binary to allow it to run without root access (These options allow
#    raw packet captures and network interface manipulation):
#
#    setcap cap_net_raw,cap_net_admin=eip /usr/sbin/tcpdump
#
#    Optionally, check that the permissions are correct:
#
#    # ls -l /usr/sbin/tcpdump
#    -rwxr-x--- 1 root pcap 770776 Feb 19  2011 /usr/sbin/tcpdump
#
#    # getcap /usr/sbin/tcpdump
#    /usr/sbin/tcpdump = cap_net_admin,cap_net_raw+eip
#
#    Optionally, symlink the tcpdump binary to a directory that is in the path for a normal user:
#
#    ln -s /usr/sbin/tcpdump /usr/local/bin/tcpdump
#
#    Optionally, configure the config permissions module so that it wont reset the file permissions
#    next time you run it by adding the following to the bottom of /etc/permissions.local
#
#    /usr/sbin/tcpdump             root:pcap       0750
#     +capabilities cap_net_admin,cap_net_raw+eip
#
#    Inform that Linux kernel that it should enable file system capabilities
#    at boot by adding the following option to the kernel line in /boot/grub/menu.lst:
#
#    file_caps=1
#
#    Reboot to enable file system capabilities
#
#
# set the cap_net_admin capability on for tcpdump
#
#Add a capture group and add yourself to it:
#
sudo groupadd pcap
sudo usermod -a -G pcap $USER
#
# Next, change the group of tcpdump and set permissions:
#
sudo chgrp pcap /usr/sbin/tcpdump
sudo chmod 750 /usr/sbin/tcpdump
#
# Finally, use setcap to give tcpdump the necessary permissions:
#
# sudo setcap cap_net_raw,cap_net_admin=eip /usr/sbin/tcpdump
sudo setcap cap_net_raw,cap_net_admin,cap_net_bind_service+eip `which tcpdump`
#
