#!/bin/bash
#
# study_nfs_mounts
#
# v2.1 20171101 Bernard.Lambert@onsemi.com
#
# A script to find mounts and see what traffic they produce and the time consumed.
# Data is accumulated in a file called study_nfs_mounts_dump.txt then sent home.
# The file is renamed with host ip and timestamp then sent to home storage for SQL load.
#
# set debug on here
#set -x
#
study_nsf_home_test_dir="zbf4wh@10.253.82.59:/sim/arch/zbf4wh/stores"
#
# pick up the interface name from ifconfig
#
if_em0=`/sbin/ifconfig | grep "em0" | awk '{ print $1 }'`
if ! [ -z "$if_em0" ]; then
 #echo "em0 is not empty"
 if_2_use=$if_em0
fi
if_em1=`/sbin/ifconfig | grep "em1" | awk '{ print $1 }'`
if ! [ -z "$if_em1" ]; then
 #echo "em1 is not empty"
 if_2_use=$if_em1
fi
if_eth0=`/sbin/ifconfig | grep "eth0" | awk '{ print $1 }'`
if ! [ -z "$if_eth0" ]; then
 #echo "eth0 is not empty"
 if_2_use=$if_eth0
fi
if_eth1=`/sbin/ifconfig | grep "eth1" | awk '{ print $1 }'`
if ! [ -z "$if_eth1" ]; then
 #echo "eth1 is not empty"
 if_2_use=$if_eth1
fi
if [ -z "$if_2_use" ]; then
  echo "interfaces cannot be identified....aborting!" >> /home/zbf4wh/studynfs/study.log
  exit 1
else
  echo "if_2_use: $if_2_use" >> /home/zbf4wh/studynfs/study.log
fi
#
# when this runs we will timestamp
#
test_time=$(date -u +"%F-%H-%M-%S-Z")
#
# backup previous run and zero new file
#
if [ -f "/home/Scripts/stores/study_nfs_mounts_dump.txt" ]; then
  mv "/home/Scripts/stores/study_nfs_mounts_dump.txt /home/Scripts/stores/study_nfs_mounts_dump.bak.$test_time"
fi
#
#
# get the local machines ip address of the ethernet (RHEL eth0)
#
host_IP=`/sbin/ifconfig $if_2_use | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'`
echo "host_IP: $host_IP" >> /home/zbf4wh/studynfs/study.log
echo "if_2_use: $if_2_use" >> /home/zbf4wh/studynfs/study.log
#
# find the mounts and make a list
#
#/bin/bash ip_list_from_mount.sh
# code included here
mount | grep -o "addr=.*" | sed -e s/addr=//g |  sed -e s/client/\\n/g | tr -d '(),' | sort | uniq > mount_ip_list.txt > mount_ip_list.txt
if [ ! -f "mount_ip_list.txt" ]; then
  echo "Error making mount_ip_list.txt...exiting" >> /home/zbf4wh/studynfs/study.log
  exit 1
fi
# 
# let things settle a couple of seconds
#
sleep 2 

#
# check we go the file ip_list_from_mount.txt
#
if [ -f "mount_ip_list.txt" ]; then

  #
  # use the mounts list to run the study
  #
line_ctr=1
while read -r line; do
  #echo "line_ctr: $line_ctr"
  if [ $line_ctr -eq 1 ]; then  
    store_1=$line
    echo $store_1 >> /home/zbf4wh/studynfs/study.log
  fi
  if [ $line_ctr -eq 2 ]; then  
    store_2=$line
    echo $store_2 >> /home/zbf4wh/studynfs/study.log
  fi
  if [ $line_ctr -eq 3 ]; then  
    store_3=$line
    echo $store_3 >> /home/zbf4wh/studynfs/study.log
  fi
  if [ $line_ctr -eq 4 ]; then  
    store_4=$line
    echo $store_4 >> /home/zbf4wh/studynfs/study.log
  fi
  (( line_ctr++ ))
done < mount_ip_list.txt
  #echo "Coming out of the while read -r line < mount_ip_list.txt"
  echo "host_ip: $host_IP  store_1: $store_1  store_2: $store_2  if_2_use: $if_2_use" >> /home/zbf4wh/studynfs/study.log
else

  echo "mount_ip_list.txt file is missing...." >> /home/zbf4wh/studynfs/study.log

fi
#
# now we have all the ips for local workstation, storage1, and storage2
# 
#
# do this test n times note* set to one for now. In the tcpdump_to_from_nfs_storage_v2.sh the count is set as a switch after tcpdump
#
test_ctr=1
while [ "$test_ctr" -le "1" ]; do
  test_no=$( printf '%1d' $test_ctr )
  #echo $test_no >> study_nfs_mounts_dump.txt
  # move code into this script 
  #/bin/bash ./tcpdump_to_from_nfs_storage_v2.sh "$host_IP" "$store_1" "$store_2" "$if_2_use" >> study_nfs_mounts_dump.txt
  #
  # tcpdump_to_from_nfs_storage_v2.sh - BLL 20171031
  #
  # begin parameter passed in by command line
  #
  # station - the workstation's address
  # station=$1
  station=$host_IP
  #echo "Station: $station"
  # store_1 - the first nfs storage
  # store_1=$2
  # store_1=$store_1
  #echo "Store_1: $store_1"
  # store_2 - the second nfs storage
  # store_2=$3
  # store_3=$store_3
  #echo "Store_2: $store_2"
  # if_2_use
  # if_2_use=$4
  # if_2_use=$if_2_use
  #echo "if_2_use (tcpdump_to...): $if_2_use"
  #
  # end parameters passed in from command line 
  #
  #
  # build a tcp dump command for one workstation and two nfs mounts
  #
  # first basic part the ethernet port, capture 20 packets, ip addresses only, and flush buffers by line(packet)
  tcpdump_cmd="/usr/sbin/tcpdump -i $if_2_use -c 20 -n "
  # this is the station to the storage
  # there may be 2 3 or 4 stores  
  if [ ! -z "$store_4" ] && [ ! -z "$store_3" ] && [ ! -z "$store_2" ] && [ ! -z "$store_1" ] ; then
    tcpdump_cmd=$tcpdump_cmd" src "$station" && ( dst "$store_1" || "$store_2" || "$store_3" || "$store_4" ) "
    # or
    tcpdump_cmd=$tcpdump_cmd" || "
    # this is the station from the storage
    tcpdump_cmd=$tcpdump_cmd" dst "$station" && ( src "$store_1" || "$store_2" || "$store_3" || "$store_4" ) " 
    #
    # end building command line for four IPs
  else
    if [ -z "$store_4" ] && [ ! -z "$store_3" ] && [ ! -z "$store_2" ] && [ ! -z "$store_1" ] ; then
      tcpdump_cmd=$tcpdump_cmd" src "$station" && ( dst "$store_1" || "$store_2" || "$store_3" ) "
      # or
      tcpdump_cmd=$tcpdump_cmd" || "
      # this is the station from the storage
      tcpdump_cmd=$tcpdump_cmd" dst "$station" && ( src "$store_1" || "$store_2" || "$store_3" ) " 
      #
      # end building command line for three IPs
    else
      if [ -z "$store_4" ] && [ -z "$store_3" ] && [ ! -z "$store_2" ] && [ ! -z "$store_1" ] ; then
        tcpdump_cmd=$tcpdump_cmd" src "$station" && ( dst "$store_1" || "$store_2" ) "
        # or
        tcpdump_cmd=$tcpdump_cmd" || "
        # this is the station from the storage
        tcpdump_cmd=$tcpdump_cmd" dst "$station" && ( src "$store_1" || "$store_2" ) " 
        #
        # end building command line for two IPs
      else
        if [ -z "$store_4" ] && [ -z "$store_3" ] && [  -z "$store_2" ] && [ ! -z "$store_1" ] ; then
          tcpdump_cmd=$tcpdump_cmd" src "$station" && ( dst "$store_1" ) "
          # or
          tcpdump_cmd=$tcpdump_cmd" || "
          # this is the station from the storage
          tcpdump_cmd=$tcpdump_cmd" dst "$station" && ( src "$store_1" ) " 
          #
          # end building command line for one IP
        fi # [ -z "$store_4" ] && [ -z "$store_3" ] && [  -z "$store_2" ] && [ ! -z "$store_1" ]      one
      fi   # [ -z "$store_4" ] && [ -z "$store_3" ] && [ ! -z "$store_2" ] && [ ! -z "$store_1" ]     two
    fi     # [ -z "$store_4" ] && [ ! -z "$store_3" ] && [ ! -z "$store_2" ] && [ ! -z "$store_1" ]   three
  fi       # [ ! -z "$store_4" ] && [ ! -z "$store_3" ] && [ ! -z "$store_2" ] && [ ! -z "$store_1" ] four
  #
  # update the log
  #
  echo $tcpdum_cmd >> /home/zbf4wh/studynfs/study.log
  # run the command and echo out to study_nfs_mounts_dump.txt
  $tcpdump_cmd >> study_nfs_mounts_dump.txt 
  #
  # if you run more than 1 while loop here use this sleep timer
  #sleep 20
  #increment the test counter
  (( test_ctr++ ))
done # while [ "$test_ctr" -le "1" ] <<<<<--------can be n numbers of tests
sleep 10
#
# send the test home
#
if [ -f "study_nfs_mounts_dump.txt" ]; then
  # make parameters for file rename with timestamp
  test_time=$(date -u +"%F-%H-%M-%S-Z")
  # load into the send file name
  send_file="$station-mounts-$test_time"
  if [ -s "study_nfs_mounts_dump.txt" ]; then 
    # copy the results txt into the send file using send_file name
    echo "Copying study_nfs_mounts_dump.txt to $send_file" >> /home/zbf4wh/studynfs/study.log
    cp study_nfs_mounts_dump.txt $send_file >> /home/zbf4wh/studynfs/study.log
    # tell them whats gonna happen
    echo "Sending the file $send_file to $study_nsf_home_test_dir" >> /home/zbf4wh/studynfs/study.log
    # build the scp copy command
    copy_cmd=`scp $send_file $study_nsf_home_test_dir`
    # run the copy
    $copy_cmd >> /home/zbf4wh/studynfs/study.log
    # nap
    sleep 5
  fi # [ -s "study_nfs_mounts_dump.txt" ]
else
  # not there?
  echo "File study_nfs_mounts_dump.txt does not exist....exiting!" >> /home/zbf4wh/studynfs/study.log  
  exit 2
fi # [ -f "study_nfs_mounts_dump.txt" ]
#
# delete result files
#
if [ -f "study_nfs_mounts_dump.txt" ]; then
  rm study_nfs_mounts_dump.txt >> /home/zbf4wh/studynfs/study.log
else
  echo "File study_nfs_mounts_dump.txt does not exist....not removed!" >> /home/zbf4wh/studynfs/study.log
fi # [ -f "study_nfs_mounts_dump.txt" ]
#
if [ -f "$send_file" ]; then
  rm $send_file >> /home/zbf4wh/studynfs/study.log
else
  echo "File $send_file does not exist....not removed!" >> /home/zbf4wh/studynfs/study.log
fi #[ -f "$send_file" ]
#
if [ -f "mount_ip_list.txt" ]; then
  rm mount_ip_list.txt
else
  echo "File mount_ip_list.txt does not exist....not removed!" >> /home/zbf4wh/studynfs/study.log
fi #[ -f "mount_ip_list.txt" ]
# 
exit 0
