#!/bin/bash
#
# tcpdump_to_from_nfs_storage_v2.sh - BLL 20171031
#
# begin parameter passed in by command line
#
# station - the workstation's address
station=$1
#echo "Station: $station"
# store_1 - the first nfs storage
store_1=$2
#echo "Store_1: $store_1"
# store_2 - the second nfs storage
store_2=$3
#echo "Store_2: $store_2"
# if_2_use
if_2_use=$4
#echo "if_2_use (tcpdump_to...): $if_2_use"


#
# end parameters passed in from command line
#
#
# build a tcp dump command for one workstation and two nfs mounts
#
# first basic part the ethernet port, capture 20 packets, ip addresses only, and fush buffers by line(packet)
tcpdump_cmd="sudo /usr/sbin/tcpdump -i $if_2_use -c 20 -n "
# this is the station to the storage
tcpdump_cmd=$tcpdump_cmd" src "$station" && ( dst "$store_1" || "$store_2" ) "  
# or
tcpdump_cmd=$tcpdump_cmd" || "
# this is the station from the storage
tcpdump_cmd=$tcpdump_cmd" dst "$station" && ( src "$store_1" || "$store_2" ) " 
#
# end building command line
#
#
# check we have all the three parameters passed in
#
if [ $# -lt 4 ]; then
  echo "$tcpdump_cmd"
  echo "Parameters missing....Aborting!"
else
  # run the command-i eth0
  #echo "$tcpdump_cmd"
  $tcpdump_cmd
fi
