#!/bin/bash
#
# interconnect.sh
#
# This program uses Engineering_Compute_Strategy worksheet to create a set of lists of the interconnected sites.
# That list is then used to place testing tools on one end of the traverse and collect data from traceroute, netflow, and tcpdump.
#
# test for command line list input
if [ $# -eq 0 ]; then
  echo "Usage: $0 <input file name>"
  exit 1
fi
#
# make an output subdir
if [ ! -d "out" ]; then
  mkdir out
fi
#
# clean up if there are previous files
if [ -f "out/*.txt" ]; then
  rm out/*.txt
fi
#
# The method will be to loop through the site list and check to see what sites it goes out to and record that set in the sites list
# The site list is the leftmost column.  The collaboratipon sites are indicated as x in the columns to it right.  The columns are B through BU.
# The loop is while reading in variables from a line.
while IFS="," read a b c d e f g h i j k l m n o p q r s t u v w x y z aa ab ac ad ae af ag ah ai aj ak al am an ao ap aq ar as at au av aw ax ay az ba bc bd be bf bg bh bi bj bk bl bm bn bo bp bq br bs bt bu bv; do

  sp1=$a
  site=${sp1// /_}
  echo $site
  sp2=$b
  region=${sp2// /_}
  echo $region
  #
 if [ ! "$site" == "_" ] && [ ! "$region" == "_" ];  then
  # file name to stor results in
  site_dest="out/"$region"_"$site".txt"  
  # tell the file name 
  echo $site_dest
  # 
  # the list of site columns reads left to right (shortened for readability):
  # Bangalore,Beijing,Bien Hoa,Bucheon,Carmona,Fukuoka,Gifu,Gunma,Haifa,Hong Kong,Lapu-Lapu City,New Delhi (Bangalore),Niigata,San Miguel,Sendai,Seoul,Seremban,Shanghai,Shenzhen,Singapore,Suzhou,Taipei,Tokyo,Zhubei City,
  # Bracknell,Bratislava,Brno,Bucharest,Dubendorf,Kista,Limerick,Maidenhead,Marin,Mechelen,Munich,Oudenaarde,Piestany,Roznov,Slovenia,Toulouse,Velizy Villacoublay,Vilvoorde,Ann Arbor,Austin,Beaverton,Bedford,Belfair,
  # Burlington,Coos Bay,Corvallis,Del Mar,East Greenwich,Gresham,Irvine,Lindon,Livonia,Lower Gwynedd,Meridian,Mountain Top,Nampa,Phoenix,Plano,Pocatello,Richardson,Rochester,San Jose,Santa Clara,South Portland,Sunnyvale,
  # Twain Harte,Waterloo
  # look for x and add the site to the file
  #
  # Bangalore,Beijing,Bien Hoa,Bucheon,Carmona,Fukuoka,Gifu,Gunma 
  if [ "$c" == "x" ]; then
    echo -e "Bangalore\t" >> $site_dest
  fi
  if [ "$d" == "x" ]; then
    echo -e "Beijing\t" >> $site_dest
  fi
  if [ "$e" == "x" ]; then
    echo -e "Bien Hoa\t" >> $site_dest
  fi
  if [ "$f" == "x" ]; then
    echo -e "Bucheon\t" >> $site_dest
  fi
  if [ "$g" == "x" ]; then
    echo -e "Carmona\t" >> $site_dest
  fi
  if [ "$h" == "x" ]; then
    echo -e "Fukuoka\t" >> $site_dest
  fi
  if [ "$i" == "x" ]; then
    echo -e "Gifu\t" >> $site_dest
  fi
  if [ "$j" == "x" ]; then
    echo -e "Gunma\t" >> $site_dest
  fi
  # Haifa,Hong Kong,Lapu-Lapu City,New Delhi (Bangalore),Niigata,San Miguel
  if [ "$k" == "x" ]; then
    echo -e "Haifa\t" >> $site_dest
  fi
  if [ "$l" == "x" ]; then
    echo -e "Hong Kong\t" >> $site_dest
  fi
  if [ "$m" == "x" ]; then
    echo -e "Lapu-Lapu City\t" >> $site_dest
  fi
  if [ "$n" == "x" ]; then
    echo -e "New Dehli (Bangalore)\t" >> $site_dest
  fi
  if [ "$o" == "x" ]; then
    echo -e "Niigata\t" >> $site_dest
  fi
  if [ "$p" == "x" ]; then
    echo -e "San Miguel\t" >> $site_dest
  fi
  # Sendai,Seoul,Seremban,Shanghai,Shenzhen,Singapore,Suzhou,Taipei,Tokyo,Zhubei City
  if [ "$q" == "x" ]; then
    echo -e "Sendai\t" >> $site_dest
  fi
  if [ "$r" == "x" ]; then
    echo -e "Seoul\t" >> $site_dest
  fi
  if [ "$s" == "x" ]; then
    echo -e "Seremban\t" >> $site_dest
  fi
  if [ "$t" == "x" ]; then
    echo -e "Shanghai\t" >> $site_dest
  fi
  if [ "$u" == "x" ]; then
    echo -e "Shenzhen\t" >> $site_dest
  fi
  if [ "$v" == "x" ]; then
    echo -e "Singapore\t" >> $site_dest
  fi
  if [ "$w" == "x" ]; then
    echo -e "Suzhou\t" >> $site_dest
  fi
  if [ "$x" == "x" ]; then
    echo -e "Taipei\t" >> $site_dest
  fi
  if [ "$y" == "x" ]; then
    echo -e "Tokyo\t" >> $site_dest
  fi
  if [ "$z" == "x" ]; then
    echo -e "Zhubei City\t" >> $site_dest
  fi
  # Bracknell,Bratislava,Brno,Bucharest,Dubendorf,Kista,Limerick,Maidenhead,Marin
  if [ "$aa" == "x" ]; then
    echo -e "Bracknell\t" >> $site_dest
  fi
  if [ "$ab" == "x" ]; then
    echo -e "Bratislava\t" >> $site_dest
  fi
  if [ "$ac" == "x" ]; then
    echo -e "Brno\t" >> $site_dest
  fi
  if [ "$ad" == "x" ]; then
    echo -e "Bucharest\t" >> $site_dest
  fi
  if [ "$ae" == "x" ]; then
    echo -e "Dubendorf\t" >> $site_dest
  fi
  if [ "$af" == "x" ]; then
    echo -e "Kista\t" >> $site_dest
  fi
  if [ "$ag" == "x" ]; then
    echo -e "Limerick\t" >> $site_dest
  fi
  if [ "$ah" == "x" ]; then
    echo -e "Maidenhead\t" >> $site_dest
  fi
  if [ "$ai" == "x" ]; then
    echo -e "Marin\t" >> $site_dest
  fi
  # Mechelen,Munich,Oudenaarde,Piestany,Roznov,Slovenia,Toulouse,Velizy Villacoublay,Vilvoorde,Ann Arbor
  if [ "$aj" == "x" ]; then
    echo -e "Mechelen\t" >> $site_dest
  fi
  if [ "$ak" == "x" ]; then
    echo -e "Munich\t" >> $site_dest
  fi
  if [ "$al" == "x" ]; then
    echo -e "Oudenaarde\t" >> $site_dest
  fi
  if [ "$am" == "x" ]; then
    echo -e "Piestany\t" >> $site_dest
  fi
  if [ "$an" == "x" ]; then
    echo -e "Roznov\t" >> $site_dest
  fi
  if [ "$ao" == "x" ]; then
    echo -e "Slovenia\t" >> $site_dest
  fi
  if [ "$ap" == "x" ]; then
    echo -e "Toulouse\t" >> $site_dest
  fi
  if [ "$aq" == "x" ]; then
    echo -e "Valizy\t" >> $site_dest
  fi
  if [ "$ar" == "x" ]; then
    echo -e "Villacoublay\t" >> $site_dest
  fi
  if [ "$as" == "x" ]; then
    echo -e "Vilvoorde\t" >> $site_dest
  fi
  if [ "$at" == "x" ]; then
    echo -e "Ann Arbor\t" >> $site_dest
  fi
  # Austin,Beaverton,Bedford,Belfair,Burlington,Coos Bay,Corvallis,Del Mar,East Greenwich,Gresham
  if [ "$au" == "x" ]; then
    echo -e "Austin\t" >> $site_dest
  fi
  if [ "$av" == "x" ]; then
    echo -e "Beaverton\t" >> $site_dest
  fi
  if [ "$aw" == "x" ]; then
    echo -e "Bedford\t" >> $site_dest
  fi
  if [ "$ax" == "x" ]; then
    echo -e "Belfair\t" >> $site_dest
  fi
  if [ "$ay" == "x" ]; then
    echo -e "Burlington\t" >> $site_dest
  fi
  if [ "$az" == "x" ]; then
    echo -e "Coos Bay\t" >> $site_dest
  fi
  if [ "$ba" == "x" ]; then
    echo -e "Corvallis\t" >> $site_dest
  fi
  if [ "$bb" == "x" ]; then
    echo -e "Del Mar\t" >> $site_dest
  fi
  if [ "$bc" == "x" ]; then
    echo -e "East Greenwich\t" >> $site_dest
  fi
  if [ "$bd" == "x" ]; then
    echo -e "Gresham\t" >> $site_dest
  fi
  # Irvine,Lindon,Livonia,Lower Gwynedd,Meridian,Mountain Top,Nampa,Phoenix,Plano,Pocatello,Richardson,Rochester,San Jose,Santa Clara,South Portland,Sunnyvale,Twain Harte,Waterloo
  if [ "$be" == "x" ]; then
    echo -e "Irvine\t" >> $site_dest
  fi
  if [ "$bf" == "x" ]; then
    echo -e "Lindon\t" >> $site_dest
  fi
  if [ "$bg" == "x" ]; then
    echo -e "Livonia\t" >> $site_dest
  fi
  if [ "$bh" == "x" ]; then
    echo -e "Lower Gwynedd\t" >> $site_dest
  fi
  if [ "$bi" == "x" ]; then
    echo -e "Meridian\t" >> $site_dest
  fi
  if [ "$bj" == "x" ]; then
    echo -e "Mountain Top\t" >> $site_dest
  fi
  if [ "$bk" == "x" ]; then
    echo -e "Nampa\t" >> $site_dest
  fi
  if [ "$bl" == "x" ]; then
    echo -e "Phoenix\t" >> $site_dest
  fi
  if [ "$bm" == "x" ]; then
    echo -e "Plano\t" >> $site_dest
  fi
  if [ "$bn" == "x" ]; then
    echo -e "Pocatello\t" >> $site_dest
  fi
  if [ "$bo" == "x" ]; then
    echo -e "Richardson\t" >> $site_dest
  fi
  if [ "$bp" == "x" ]; then
    echo -e "Rochester\t" >> $site_dest
  fi
  if [ "$bq" == "x" ]; then
    echo -e "San Jose\t" >> $site_dest
  fi
  if [ "$br" == "x" ]; then
    echo -e "Santa Clara\t" >> $site_dest
  fi
  if [ "$bs" == "x" ]; then
    echo -e "South Portland\t" >> $site_dest
  fi
  if [ "$bt" == "x" ]; then
    echo -e "Sunnyvale\t" >> $site_dest
  fi
  if [ "$bu" == "x" ]; then
    echo -e "Twain Harte\t" >> $site_dest
  fi
  if [ "$bv" == "x" ]; then
    echo -e "Waterloo\t" >> $site_dest
  fi
 fi
done < $1
ls -latr out |less
wc -l out/*
