







# Fuction: Test an IP address for validity:
# Usage:
#      valid_ip IP_ADDRESS
#      if [[ $? -eq 0 ]]; then echo good; else echo bad; fi
#   OR
#      if valid_ip IP_ADDRESS; then echo good; else echo bad; fi
#

set -x

function valid_ip()
{
    local  ip=$1
    local  stat=1

    if [[ $ip =~ ^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$ ]]; then
      OIFS=$IFS
      IFS='.'
      ip=($ip)
      IFS=$OIFS
      [[ ${ip[0]} -le 255 && ${ip[1]} -le 255 && ${ip[2]} -le 255 && ${ip[3]} -le 255 ]]
      stat=$?
    fi
    return $stat
}

function curl_ip()
{

  string_of_curls="handle,startAddress,endAddress,name,type,country"
  IFS="," read -r v1 v2 v3 v4 v5 v6 <<< $string_of_curls
  handle=`curl -s "http://rdap.apnic.net/ip/$1" |  $HOME/anaconda3/bin/python3 -c "import sys,json; print(json.load(sys.stdin)['$v1'])"`
  startAddress=`curl -s "http://rdap.apnic.net/ip/$1" |  $HOME/anaconda3/bin/python3 -c "import sys, json; print(json.load(sys.stdin)['$v2'])"`
  endAddress=`curl -s "http://rdap.apnic.net/ip/$1" |  $HOME/anaconda3/bin/python3 -c "import sys, json; print(json.load(sys.stdin)['$v3'])"`
  name=`curl -s "http://rdap.apnic.net/ip/$1" |  $HOME/anaconda3/bin/python3 -c "import sys, json; print(json.load(sys.stdin)['$v4'])"`
  type=`curl -s "http://rdap.apnic.net/ip/$1" |  $HOME/anaconda3/bin/python3 -c "import sys, json; print(json.load(sys.stdin)['$v5'])"`
  country=`curl -s "http://rdap.apnic.net/ip/$1" |  $HOME/anaconda3/bin/python3 -c "import sys, json; print(json.load(sys.stdin)['$v6'])"`

}
if valid_ip "$1"; then
  
  curl_ip $1

fi 

echo "Handle: $handle  Start Address: $startAddress  End Address: $endAddress  Name: $name  Type: $type  Country: $country"

#if
