#!/bin/bash
#
# nmap_trace.sh
#
# script feeds cliosoft server list to
# nmap -p5096 --traceroute -iL onsemi-cliosoft-servers.lst
who_is_running_this=`whoami`
if [ ! "$who_is_running_this" == "root" ]; then
  echo "This script must be run as root!..Quitting"
  exit 2
fi
if [ "$#" -ne 1 ]; then
  echo "Usage: $0 <input file name>"
  exit 1
fi
if [ ! -d "tests" ]; then
  mkdir tests
fi
input_file=$1
ctr=0
while read v1 v2 v3 v4; do
  ((ctr++))
  if [ ! "$v1" == "" ]; then
    echo -ne "${ctr}|"
    nmap -p5096 --traceroute $v1 > tests/traceroute-$v1
    sleep 1
  else
    ctr=$ctr-1
  fi
done < $input_file
echo -e ${ctr}" Traceroutes run using nmap -p5096 --traceroute using list: "$input_file"\n"
exit 0
