#!/bin/bash
#
# trace_to_text.sh
#
# A script to do traceroute to an IP or iplist.txt to see how long the traverse takes.
# Data is accumulated in a file called study_trace_dump.txt then sent home.
# The file is renamed with host ip,destination ip, and timestamp then sent to home storage for SQL load.
#
# set debug on here
#set -x
#
# set file parameters here
#
#
# input file from command line
#
in_file=$1
# local user (can be same as destination user)
src_user="zbf4wh"
# local directory
local_dir="/home/$src_user"
# scripts directory
scripts_dir="/Scripts"
# local program directory
trace="/trace"
# local tests dir
local_tests_dir="/tests"
# local dump filename
trace_filename="/study_trace_dump.txt"
# local dump full path and name
local_dump="$local_dir$scripts_dir$trace$tests$trace_filename"

# destination user (must have ssh keys to match at destination so password is not needed)
dest_user="zbf4wh"
# destination machine IP
dest_mach_ip="10.253.82.59"
# destination bulk storage mount
dest_bulk_mount="/sim/arch"
# destination directory
dest_trace_dump_dir="$dest_user@$dest_mach_ip:$dest_bulk_mount/$dest_user$trace"
# local log file
local_log="/home/$src_user/$scripts_dir$trace$tests/study_trace.log"
#
# clear log if it exists and is requested
if [ -f "$local_log" ]; then
  clear
  echo "A local log file $local_log exists."
  read -p "Want to clear it? Y/N? " clear_log
fi
# do it if they said yes
if [ "$clear_log"=="Y" ] || [ "$clear_log"=="y" ]; then
  echo "Local log cleared..."
  rm $local_log
fi # [ "$clear_log"=="Y" ] || [ "$clear_log"=="y" ]
#
# pick up the interface name from ifconfig
#
# interface em0
if_em0=`/sbin/ifconfig | grep "em0" | awk '{ print $1 }'`
if ! [ -z "$if_em0" ]; then
  #echo "em0 is not empty"
  if_2_use=$if_em0
fi
#
# interface em1
if_em1=`/sbin/ifconfig | grep "em1" | awk '{ print $1 }'`
if ! [ -z "$if_em1" ]; then
  # echo "em1 is not empty"
  if_2_use=$if_em1
fi
#
# interface eth0
if_eth0=`/sbin/ifconfig | grep "eth0" | awk '{ print $1 }'`
if ! [ -z "$if_eth0" ]; then
  #echo "eth0 is not empty"
  if_2_use=$if_eth0
fi
#
# interface eth1
if_eth1=`/sbin/ifconfig | grep "eth1" | awk '{ print $1 }'`
if ! [ -z "$if_eth1" ]; then
  #echo "eth1 is not empty"
  if_2_use=$if_eth1
fi
#
# test that we got a good interface from the above 4 tests [em0,em1,eth0,and eth1]
#
if [ -z "$if_2_use" ]; then
  echo "interfaces cannot be identified....aborting!" >> $local_log
  exit 1
else
  echo "This test will use interface: $if_2_use" >> $local_log
fi
#
# when this runs we will timestamp
#
test_time=$(date -u +"%F-%H-%M-%S-Z")

#
# backup previous run
#
if [ -f "$local_dump" ]; then
  dump_bak="$local_dump.bak.$test_time"
  echo "mv $local_dump $dump_bak" >> $local_log 
  mv $local_dump $dump_bak 
fi
#
#
# get the local machines ip address of the ethernet from above routine
#
host_IP=`/sbin/ifconfig $if_2_use | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'`
echo "Using host_IP: $host_IP" >> $local_log
echo "Using interface: $if_2_use" >> $local_log
#
# clear the screen
#
clear
#
# add a line
#
echo
#
# test for a subdirectory for storing the test temporarily
#
if [[ ! -d "$local_dir$scripts_dir$trace$tests" ]]; then
  echo "A subdirectory named 'tests' is missing." >> $local_log
  echo "Making subdirectory 'tests'..." >> $local_log
  mkdir $local_dir$scripts_dir$trace$tests
fi
#
# test for parameters passed from command line
#
if [[ $# -eq 0 ]];then
  echo
  echo "             Parameters are missing!"
  echo "Useage:  trace_to_text.sh < ip address list | hostname list | ip and hostname list >"
  echo
  read -p "Hit any key to exit....."
  exit 1
else
  #
  # housekeeping in case a file already exists
  #
  if [ -f "$local_dir$scripts_dir$trace$tests/$host_IP-to-$test_ip-$test_time.txt" ]; then
    rm $local_dir$scripts_dir$trace$tests/$host_IP-to-$test_ip-$test_time.txt
  fi
  #
  # process the list.  making one file with all tests in it.
  #
  #
  # set the test time for the file name
  #
  test_time=$(date -u +"%F-%H-%M-%S-Z")
  while IFS=" " read in1; do
    test_ip=$in1
    #
    interim_test_time=$(date -u +"%F-%H-%M-%S-Z")
    echo "Test from $host_IP to $test_ip began at $interim_test_time"
    echo "Test began at $test_time" >> $local_log
    echo "Traceroutes to $in1 will be saved in $local_dir$scripts_dir$trace$tests/test-$test_time.txt." >> $local_log
    echo "Please note the use of UTC or ZULU time appended to the test filename." >> $local_log
    system_local_time=$(date +"%F-%H-%M-%S-K")
    system_zulu_time=$(date -u +"%F-%H-%M-%S-Z")    
    echo "System Local Time: $system_local_time" >> $local_log
    echo "System ZULU Time: $system_zulu_time" >> $local_log
    echo "System Local Time: $system_local_time" >> $local_dir$scripts_dir$trace$tests/$host_IP-to-$test_ip-$test_time.txt
    echo "System ZULU Time: $system_zulu_time" >> $local_dir$scripts_dir$trace$tests/$host_IP-to-$test_ip-$test_time.txt
    echo "Begin traceroute from $host_IP to $test_ip" >> $local_log
    echo "Begin traceroute from $host_IP to $test_ip" >> $local_dir$scripts_dir$trace$tests/$host_IP-to-$test_ip-$test_time.txt
    #
    # run the test and add it to the test file for as many IPs as are in the input list
    #
    traceroute -n $test_ip  | tail -n+2 | awk  '{ print $1"\t"$2"\t"$3 }' >> $local_dir$scripts_dir$trace$tests/$host_IP-to-$test_ip-$test_time.txt
    #
    # time stamp this pass in log file
    #
    interim_test_time=$(date -u +"%F-%H-%M-%S-Z")
    echo "Test from $host_IP to $test_ip completed at $interim_test_time" >> $local_log
    echo "Test from $host_IP to $test_ip completed at $interim_test_time" 
    # wait for output to stdout to finish
    sleep 20
    echo "End traceroute from $host_IP to $test_ip" >> $local_dir$scripts_dir$trace$tests/$host_IP-to-$test_ip-$test_time.txt
    echo "End traceroute from $host_IP to $test_ip" >> $local_log
  done < $in_file # while IFS=" " read in1; do
  #
  # set the finish timew
  #
  finish_test_time=$(date -u +"%F-%H-%M-%S-Z")
  #
  # send the test home
  #
  if [ -f "$local_dir$scripts_dir$trace$tests/$host_IP-to-$test_ip-$test_time.txt" ]; then
    # send_file naming
    send_file="$local_dir$scripts_dir$trace$tests/$host_IP-to-$test_ip-$test_time.txt"
    echo "Source is: $send_file" >> $local_log
    # destination file naming
    dest_file="$dest_trace_dump_dir/$host_IP-to-$test_ip-$test_time.txt"
    echo "Destination is: $dest_file" >> $local_log
    # tell them whats gonna happen
    echo "Sending the file $send_file to $dest_file" >> $local_log
    # build the scp copy command
    copy_cmd=`scp $send_file $dest_file`
    echo "SCP command is: scp $send_file $dest_file" >> $local_log
    # run the copy
    $copy_cmd >> $local_log
    # nap
    sleep 5
    echo "Removing file $send_file after scp" >> $local_log
    rm $send_file
  else
    # not there?
    echo "File $local_dir$scripts_dir$trace$tests/$host_IP-to-$test_ip-$test_time.txt does not exist....exiting!" >> $local_log  
    exit 2
  fi # [ -f "study_nfs_mounts_dump.txt" ]

fi # [[ $# -eq 0 ]]

exit 0
